//
//  OPEntity.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/27/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPEntity.h"

#define OP_NO_TEXTURE 0

@implementation OPEntity
- (id)initWithLocation:(OPPoint)inLocation andSize:(OPSize)inSize
{
	self = [super initWithLocation:inLocation andSize:inSize];  
	if(self != nil) {
		velocity = NSZeroPoint;
		textures = [[NSMutableDictionary alloc] init];
		maxHealth = 0;
		currentHealth = 0;
		[self setTexture:OP_NO_TEXTURE];
	}
	return self;
}

- (void)addTextureID:(GLuint)theID withName:(NSString *)name
{
	[textures setObject:[NSNumber numberWithUnsignedInt:theID] forKey:name];
}

- (void)dealloc
{
	[textures release];
	[super dealloc];
}

- (void)update
{
	if(movingUp) {
		velocity.y = 1.0;
	}else
	if(movingDown) {
		velocity.y = -1.0;
	}
	if(movingLeft) {
		velocity.x = -1.0;
	}else
	if(movingRight) {
		velocity.x = 1.0;
	}
	if(![self isMovingHorizontal]) {
		velocity.x = 0;
	}
	if(![self isMovingVertical]) {
		velocity.y = 0;
	}
	location.x += (moveSpeed * velocity.x);
	location.y += (moveSpeed * velocity.y);
}

- (void)setMovingLeft:(BOOL)value
{
	movingLeft = value;
}

- (void)setMovingRight:(BOOL)value
{
	movingRight = value;
}

- (void)setMovingUp:(BOOL)value
{
	movingUp = value;
}

- (void)setMovingDown:(BOOL)value
{
	movingDown = value;
}

- (BOOL)isMovingUp
{
	return movingUp;
}

- (BOOL)isMovingDown
{
	return movingDown;
}

- (BOOL)isMovingLeft
{
	return movingLeft;
}

- (BOOL)isMovingRight
{
	return movingRight;
}

- (BOOL)isMovingHorizontal
{
	return (movingLeft || movingRight);
}

- (BOOL)isMovingVertical
{
	return (movingUp || movingDown);
}

- (void)stopHorizontal
{
	movingUp = NO;
	movingDown = NO;
}

- (void)stopVertical
{
	movingLeft = NO;
	movingRight = NO;
}

- (void)stop
{
	[self stopHorizontal];
	[self stopVertical];
}

- (BOOL)isMoving
{
	return  ([self isMovingUp] || [self isMovingDown] ||
			 [self isMovingLeft] || [self isMovingRight]);
}

- (BOOL)checkCollision:(OPSprite *)spriteToCheck
{
	BOOL collisionOccurred = NO;

	if(spriteToCheck != nil) {
		OPRect theRect = [self collisionRect];
		OPRect otherRect = [spriteToCheck collisionRect];
		if (NSIntersectsRect(theRect, otherRect)) {
			BOOL resetX = NO;
			BOOL resetY = NO;
			// Will backing out X only work?
			if ([self isMovingHorizontal]) {
				theRect.origin.x -= (moveSpeed * velocity.x);
				resetX = !NSIntersectsRect(theRect, otherRect);
				theRect.origin.x += (moveSpeed * velocity.x);
			}
			
			// If not backing out X only, then does Y only work?
			if ([self isMovingVertical]) {
				if (!resetX) {
					theRect.origin.y -= (moveSpeed * velocity.y);
					resetY = !NSIntersectsRect(theRect, otherRect);
					theRect.origin.y += (moveSpeed * velocity.y);
				}
			}
			
			// Backing out only one did not work, do both
			if (!resetX && !resetY) {
				resetX = [self isMovingHorizontal];
				resetY = [self isMovingVertical];
			}
			
			if (resetX) {
				location.x -= (moveSpeed * velocity.x);
				collisionOccurred = YES;
			}
			if (resetY) {
				location.y -= (moveSpeed * velocity.y);
				collisionOccurred = YES;
			}
		}
	}
	return collisionOccurred;

}

- (GLuint)textureWithName:(NSString *)textureName
{
	NSNumber *texture = [textures objectForKey:textureName];
	GLuint textID = 0;
	if(texture != nil) {
		textID = [texture unsignedIntValue];
	}
	return textID;
}

- (BOOL)hurt
{
	return NO;
}

- (void)heal
{
}

- (int)attack
{
	return 0;
}

- (int)defense
{
	return 0;
}

- (int)currentHealth
{
	return 0;
}

- (int)maxHealth
{
	return 0;
}

- (OPDirection)movingDirection
{
	OPDirection theDirection = -1;
	if([self isMovingUp]) {
		theDirection = OPUp;
	} else if([self isMovingDown]) {
		theDirection = OPDown;
	} else if([self isMovingLeft]) {
		theDirection = OPLeft;
	} else if([self isMovingRight]) {
		theDirection = OPRight;
	}
	return theDirection;
}


@end
